class Zombies expands Mutator config(Zombies5);

var() config int NZombiesCount; //total amount of zombies
var() config int NHordeSize; // spawn groups of n zombies
var() config int ZombieHealth;  // optional health setting.  default 100
var() config int CheckRate; // How often to check if more zombies need to spawn.  In secs.
var() config bool bScoreDeathByZombie, bScoreZombieKills, bNegScoring, bDebug;

var string ZombieClasses[18]; //name of Classes inherited from twt_zombiepawn for dynamic loading

var NavigationPoint PNodes[5001];// array of spawnpoints
var int NavNodeCount;  // amount of navigation nodes in this map
var int INeededZombies, TWTZCount, ZKillCnt; // if i need enough zombies to spawn a new horde, then is time to respawn a new wave of zombies

function PostBeginPlay()
{
   local NavigationPoint N;

   Super.PostBeginPlay();

   INeededZombies=NZombiesCount;
   ZKillCnt = 0;
   for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
   {
      if ((N.IsA('PathNode') || N.IsA('SpawnPoint')) && !N.Region.Zone.bWaterZone)
      {
	 if (NavNodeCount <= 5000)
	 {
	    PNodes[NavNodeCount] = N;
	    NavNodeCount++;
	 }
         N.bPlayerOnly = False;
      }
   }
   log("Zombies5 Init - Spawnpoint count: "$NavNodeCount);
   if (NavNodeCount >= 1)
   {
	Level.Game.RegisterDamageMutator(Self);
	SetTimer(2,true);
   }
}

function bool GetSpawnPoint(out Vector Location, int HordeRadius)
{
   local NavigationPoint N;
   local PlayerPawn radiusActor;
   local bool NearPlayer;
   local Actor CollidingActor;
   local vector traceStart,traceEnd,Extent;
   local vector HitLocation, HitNormal;

   N = PNodes[Rand(NavNodeCount)];

   if(N.PlayerCanSeeMe() == false)
   {
      nearplayer = false;
      foreach RadiusActors(class'PlayerPawn', radiusActor, 500, N.Location) //500 = 30meters around
      {
         if (radiusActor != none)
         {
            NearPlayer=true;
	    break;
	 }
      }
      if (nearplayer == false)
      {
	 traceStart = N.location;
	 traceEnd = N.location;
	 traceStart.z += 10;
	 traceEnd.z += 10 + 39*2;

	 Extent.X = HordeRadius;
	 Extent.Y = HordeRadius;
	 Extent.Z = 39; //39 = zombie's CollisionHeight

	 CollidingActor=Trace(HitLocation, HitNormal,traceStart,traceEnd,true,Extent);
	 if (CollidingActor !=none)
	 {
	    if ( !CollidingActor.bIsPawn && CollidingActor != Level)
	    {
	       Location = N.location;
	       return true;
	    }
	 }
      }
   }
   Location = N.location;
   return false;
}

function SpawnHordes()
{
   local int ThisHordeSize, HordeRadius, INZ;
   local int ZombPerRow; //spawn a block of N x N zombies
   local int retries,maxRetries;
   local int row, col;
   local int around,freeSpace;
   local bool collision;
   local Vector location,location2;

   around = 2.5; //free space around zombie spawnpoint = [zombie.collitionradius * around]
   maxRetries = 10;
   retries = 0;
   if (INeededZombies > NavNodeCount)
	INZ = NavNodeCount;
   else
	INZ = INeededZombies;
   while(INZ > 0 && retries < maxRetries)
   {
      if(INZ > NHordeSize)
         ThisHordeSize = NHordeSize;	  //spawn a complete horde
      else ThisHordeSize = INZ; //spawn all remaining zombies

      if(retries == maxRetries-1 && ThisHordeSize >8)
      {
	 retries = 0;
	 ThisHordeSize = 0.7 * ThisHordeSize;
      }
      ZombPerRow =  abs(sqrt(ThisHordeSize)+1);
      if ( Square(ZombPerRow-1) == ThisHordeSize)
         ZombPerRow--; // exact  n x n  box
      HordeRadius= ( (1.4142135 * around) * 35 * (ZombPerRow/2));

      while(INZ > 0 && retries < maxRetries)
      {
	 if (GetSpawnPoint(Location,HordeRadius) == false)
	 {
      	    if(retries != maxRetries-1)
	    {
	       retries++;
	       continue;
	    }
         }
	 location.x = location.x - ((around/2)* 35 * (ZombPerRow-1));
	 location.y = location.y - ((around/2)* 35 * (ZombPerRow-1));

	 for (row = 1; row <= ZombPerRow; row++)
            for (col = 1;( col <= ZombPerRow && INZ > 0 && ThisHordeSize > 0 ); col++)
	    {
    	       location2 = location;
      	       location2.x += (row * (35 * around)) - (35 * (around/2));
	       location2.y += (col * (35 * around)) - (35 * (around/2));

	       if (around > 1)
	       {
		  freeSpace = around - 1;
		  location2.x += 35*((frand()*freeSpace) - freeSpace/2);
		  location2.y += 35*((frand()*freeSpace) - freeSpace/2);
	       }

	       if (SpawnZombie(location2) == true)
	       {
		  INZ--;
		  ThisHordeSize--;
	       }
	    }//end for (horde)
            break; // success spawning horde, quit retrying and go spawn next horde (exit inner while loop)
         }// end inner while
      }// end outer while
   SetTimer(CheckRate,true);
}

function bool SpawnZombie(Vector Location)
{
   local TWT_ZombiePawn NewZombie;
   local Class<TWT_ZombiePawn> ZombieClass;
   local int randm;
   
   randm = Rand(19);
      switch(randm)
      {
          case 0:
            ZombieClass=Class'TWT_ZombieGordo';
            break;
          case 1:
            ZombieClass=Class'TWT_ZombieTraje1';
            break;
           case 2:
            ZombieClass=Class'TWT_ZombieNurse';
            break;
           case 3:
            ZombieClass=Class'TWT_ZombieTraci';
            break;
           case 4:
            ZombieClass=Class'TWT_ZombieBalin';
            break;
           case 5:
            ZombieClass=Class'TWT_ZombieTraje2';
            break;
           case 6:
            ZombieClass=Class'TWT_ZombieTraje3';
            break;
           case 7:
            ZombieClass=Class'TWT_ZombieTraci2';
            break;
           case 8:
            ZombieClass=Class'TWT_ZombieBalin02';
            break;
           case 9:
            ZombieClass=Class'TWT_ZombieBalin03';
            break;
           case 10:
            ZombieClass=Class'TWT_ZombieBalin04';
            break;
           case 11:
            ZombieClass=Class'TWT_ZombieBalin05';
            break;
           case 12:
            ZombieClass=Class'TWT_ZombieBalin06';
            break;
           case 13:
            ZombieClass=Class'TWT_ZombieGordo02';
            break;
           case 14:
            ZombieClass=Class'TWT_ZombieGordo03';
            break;
           case 15:
            ZombieClass=Class'TWT_ZombieGordo04';
            break;
           case 16:
            ZombieClass=Class'TWT_ZombieGordo05';
            break;
           case 17:
            ZombieClass=Class'TWT_ZombieGordo06';
            break;
           case 18:
            ZombieClass=Class'TWT_ZombieGordo01';
            break;
      }

   if (ZombieClass == None)
   {
      return false;
   }
   Location.z-=10;
   NewZombie=Spawn(ZombieClass,,,Location);
   if ( NewZombie == None )
   {
      return false;
   }
   else
   {
      NewZombie.Skill=Rand(3)+1;
      NewZombie.Intelligence=BRAINS_Human;
      NewZombie.bIsPlayer=False;
      NewZombie.Team=255;
      NewZombie.Health=ZombieHealth;
      NewZombie.Enemy=None;
   }
   return true;
}

function bool PreventDeath(Pawn Other, Pawn Killer, name damageType, vector HitLocation)
{
	if ((TWT_ZombiePawn(Killer) != None) && ((PlayerPawn(Other) != None) || (Bot(Other) != None)))
	{
		if (bScoreDeathByZombie)
			{ Other.PlayerReplicationInfo.Deaths += 1; }
	}
   return Super.PreventDeath(Other, Killer, damageType, HitLocation);
}

function bool AlwaysKeep (Actor Other)
{
   if (TWT_ZombiePawn(other) != None)
   {
	return True;
   }
   return Super.AlwaysKeep(Other);
}

event Timer()
{
	local TWT_ZombiePawn TP;

	TWTZCount = 0;
	foreach AllActors(class'TWT_ZombiePawn', TP)
	{
		if (TP.Health > 0) { TWTZCount++; }
	}
	INeededZombies = NZombiesCount - TWTZCount;	
	if (INeededZombies == 0) { disable('Timer'); } else { SpawnHordes(); }
	if (bDebug) { BroadcastMessage("Zombie Time!  INeededZombies = "$INeededZombies@"  TWTZCount = "$TWTZCount); log("Zombie Time!  INeededZombies = "$INeededZombies@"  TWTZCount = "$TWTZCount); }
}



function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	if (((Victim.Health - ActualDamage) <= 0) && (TWT_ZombiePawn(Victim) != None))
	{
		ZKillCnt++;
		if (ZKillCnt >= NHordeSize)
			{ enable('Timer'); ZKillCnt = 0; }

		if ((TWT_ZombiePawn(Victim) != None) && ((InstigatedBy) != None && (PlayerPawn(InstigatedBy) != None) || (Bot(InstigatedBy) != None)))
		{
			if (!bScoreZombieKills)
				{
					InstigatedBy.PlayerReplicationInfo.Score -= 1;
					if (bNegScoring)
						{ InstigatedBy.PlayerReplicationInfo.Score -= 1; }

				}
		}
	}
	Super.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
   NZombiesCount=60
   NHordeSize=6
   ZombieHealth=100
   CheckRate=30
   bScoreDeathByZombie=True
   bScoreZombieKills=False
   bNegScoring=False
   bDebug=False
}
